package ga.core.evaluation;

import ga.core.individual.IIndividual;

import java.util.ArrayList;
import java.util.List;

/**
 * Abstract class for interactive fitness evaluators. This adds listener
 * handling to the {@link IInteractiveFitnessEvaluator} interface.
 * 
 * @param <T>
 *          The generic type of the individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public abstract class AbstractInteractiveEvaluator<T extends IIndividual<T>>
    implements IInteractiveFitnessEvaluator<T> {
  private final List<EvaluationListener<T>> listeners = new ArrayList<EvaluationListener<T>>();

  @Override
  public void fireNewIndividualRequested() {
    for (final EvaluationListener<T> l : listeners) {
      l.newIndividualRequested();
    }
  }

  @Override
  public void fireIndividualEvaluated(final T individual) {
    for (final EvaluationListener<T> l : listeners) {
      l.individualEvaluated(individual);
    }
  }

  @Override
  public void addEvaluationListener(final EvaluationListener<T> listener) {
    listeners.add(listener);
  }

  @Override
  public void removeEvaluationListener(final EvaluationListener<T> listener) {
    listeners.remove(listener);
  }

}
